Attribute VB_Name = "FormatTables"
Sub FormatTablesRowNoBreak()
' Runs through all tables in the document and sets allow rows to break across page to false.

' This starts the macro at the start of the document
Selection.HomeKey Unit:=wdStory

'This declares the variable that counts the number of tables.
Dim iNumber As Integer
iNumber = ActiveDocument.Tables.Count

' This stops the macro running if there are no tables
If iNumber = 0 Then
MsgBox "There are no tables in this document"
End
Else

'This declares the variable that numbers the current table.
Dim iCurrent As Integer
For iCurrent = 1 To iNumber

' This finds the next table
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""

' This selects the table
With Selection
    .SelectColumn
    .SelectRow
End With

' This formats the table. First line stops rows breaking, second indents table.
Selection.Rows.AllowBreakAcrossPages = False
Selection.Collapse

' This loops to the next table until all the tables have been processed.
Next iCurrent
End If
MsgBox "All tables have been set to Allow Row to Break Across Pages = False"
End Sub

Sub FormatTablesAll()

' Runs through all tables in the document and applies the properties defined.
' Does not give user option to skip a table.
' This starts the macro at the start of the document
Selection.HomeKey Unit:=wdStory
'This declares the variable that counts the number of tables.
Dim iNumber As Integer
iNumber = ActiveDocument.Tables.Count
' This stops the macro running if there are no tables
If iNumber = 0 Then
MsgBox "There are no tables in this document"
End
Else
'This declares the variable that numbers the current table.
Dim iCurrent As Integer
For iCurrent = 1 To iNumber
' This finds the next table
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This selects the table
With Selection
    .SelectColumn
    .SelectRow
End With
' This formats the table
With Selection.Tables(1)
    With .Borders(wdBorderLeft)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderRight)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderTop)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderBottom)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderVertical)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderHorizontal)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
' Enter other requirements here
End With
Selection.Collapse
' This loops to the next table until all the tables have been processed.
Next iCurrent
End If
MsgBox "All tables have been formatted"
End Sub

Sub FormatTablesSelected()

' Runs through all tables from a user defined start point asking user to indicate whether formatting is to be applied.
' This determines the start point
Response = MsgBox("Start here? Select No to start at beginning of document.", vbYesNoCancel)
If Response = vbYes Then
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This gives warning message if there are no tables beyond start point.
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "There are no tables after this position"
End
End If
ElseIf Response = vbNo Then
Selection.HomeKey Unit:=wdStory
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This gives warning message if there are no tables in the document.
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "There are no tables in this document"
End
End If
Else
End
End If
' This finds the next table from start point and starts the formatting
Do
Response = MsgBox("Apply changes to this table?", vbYesNoCancel)
If Response = vbYes Then
' This selects the table
With Selection
.SelectColumn
.SelectRow
End With
' This formats the table
With Selection.Tables(1)
    With .Borders(wdBorderLeft)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderRight)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderTop)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderBottom)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderVertical)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
    With .Borders(wdBorderHorizontal)
        .LineStyle = wdLineStyleSingle
        .Color = RGB(50, 100, 155)
    End With
' Enter other requirements here
End With
' This collapses the selection and moves to the next table or displays the end of tables message
Selection.Collapse wdCollapseEnd
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "End of tables in this document"
End
End If
ElseIf Response = vbNo Then
' Selects Table and then collapses to point beyond the table
With Selection
.SelectColumn
.SelectRow
End With
Selection.Collapse wdCollapseEnd
' Looks for next table and loops if found or ends macro
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "End of tables in this document"
End
End If
Else
End
End If
Loop
MsgBox "End of tables in this document"
End Sub
Sub FormatTablesScroll()

' Runs through all tables from a user defined start point.
' This determines the start point
Response = MsgBox("Start here? Select No to start at beginning of document.", vbYesNoCancel)
If Response = vbYes Then
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This gives warning message if there are no tables beyond start point.
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "There are no tables after this position"
End
End If
ElseIf Response = vbNo Then
Selection.HomeKey Unit:=wdStory
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This gives warning message if there are no tables in the document.
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "There are no tables in this document"
End
End If
Else
End
End If
' This finds the next table from start point and starts the formatting
Do
Response = MsgBox("Go to next table?", vbYesNo)
If Response = vbYes Then
' This selects the table
With Selection
    .SelectColumn
    .SelectRow
End With
Selection.Collapse wdCollapseEnd
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "End of tables in this document"
End
End If
Else
End
End If
Loop
MsgBox "End of tables in this document"
End Sub

Sub FormatTablesSelected2()

' Like FormatTablesSelected, this gives the user the option of running the procedure against a table
' or not. The difference is that this procedure always starts from the beginning of the document.

Selection.HomeKey Unit:=wdStory
' From here to ELSE line runs the procedure if first table is at start of document
If Selection.Information(wdWithInTable) = True Then
            Do
            Response = MsgBox("Apply changes to this table?", vbYesNoCancel)
            If Response = vbYes Then
            ' This makes the required changes
            With Selection.Tables(1)
                With .Borders(wdBorderLeft)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderRight)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderTop)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderBottom)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderVertical)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderHorizontal)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
            ' Enter other requirements here
            End With
            ' This collapses the selection and moves to the next table or displays the end of tables message
            Selection.MoveDown Unit:=wdLine, Count:=1
            Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
            If Selection.Information(wdWithInTable) = True Then
            Else
            MsgBox "End of tables in this document"
            End
            End If
            ElseIf Response = vbNo Then
            ' Selects Table and then collapses to point beyond the table
            With Selection
            .SelectColumn
            End With
            Selection.MoveDown Unit:=wdLine, Count:=1
            ' Looks for next table and loops if found or ends macro
            Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
            If Selection.Information(wdWithInTable) = True Then
            Else
            MsgBox "End of tables in this document"
            End
            End If
            Else
            End
            End If
            Loop
            MsgBox "End of tables in this document"
Else
' From here runs the procedure if first table is NOT at start of document
            Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
            If Selection.Information(wdWithInTable) = True Then
            Do
            Response = MsgBox("Apply changes to this table?", vbYesNoCancel)
            If Response = vbYes Then
            ' This makes the required changes
            With Selection.Tables(1)
                With .Borders(wdBorderLeft)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderRight)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderTop)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderBottom)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderVertical)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
                With .Borders(wdBorderHorizontal)
                    .LineStyle = wdLineStyleSingle
                    .Color = RGB(50, 100, 155)
                End With
            ' Enter other requirements here
            End With
            ' This collapses the selection and moves to the next table or displays the end of tables message
            Selection.MoveDown Unit:=wdLine, Count:=1
            Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
            If Selection.Information(wdWithInTable) = True Then
            Else
            MsgBox "End of tables in this document"
            End
            End If
            ElseIf Response = vbNo Then
            ' Selects Table and then collapses to point beyond the table
            With Selection
            .SelectColumn
            End With
            Selection.MoveDown Unit:=wdLine, Count:=1
            ' Looks for next table and loops if found or ends macro
            Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
            If Selection.Information(wdWithInTable) = True Then
            Else
            MsgBox "End of tables in this document"
            End
            End If
            Else
            End
            End If
            Loop
            MsgBox "End of tables in this document"
            End
            Else
' From here runs the procedure if there are no tables in the document
            MsgBox "There are no tables in this document"
            End
            End If
End If
End Sub
Sub FormatTableNext()

' Applies formatting to the next table only

' The first line tests whether the cursor is in a table. If it is, the user is asked to confirm.
If Selection.Information(wdWithInTable) = True Then
Response = MsgBox("Apply changes to this table?", vbYesNo)
' If user says Yes, the procedure runs
        If Response = vbYes Then
                ' This selects the table
                With Selection
                .SelectColumn
                .SelectRow
                End With
                ' This formats the table
                With Selection.Tables(1)
                    With .Borders(wdBorderLeft)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderRight)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderTop)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderBottom)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderVertical)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderHorizontal)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                End With
                ' This collapses the selection
                Selection.Collapse wdCollapseStart
        Else
        ' If user says No, the procedure ends
        End
        End If
Else
' If the cursor was not in a table when the procedure was invoked, this section moves it
' to the next table and then runs the same procedure
        Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
        If Selection.Information(wdWithInTable) = True Then
        Response = MsgBox("Apply changes to this table?", vbYesNo)
        If Response = vbYes Then
        ' This selects the table
        With Selection
        .SelectColumn
        .SelectRow
        End With
        ' This formats the table
        With Selection.Tables(1)
            With .Borders(wdBorderLeft)
                .LineStyle = wdLineStyleSingle
                .Color = RGB(50, 100, 155)
            End With
            With .Borders(wdBorderRight)
                .LineStyle = wdLineStyleSingle
                .Color = RGB(50, 100, 155)
            End With
            With .Borders(wdBorderTop)
                .LineStyle = wdLineStyleSingle
                .Color = RGB(50, 100, 155)
            End With
            With .Borders(wdBorderBottom)
                .LineStyle = wdLineStyleSingle
                .Color = RGB(50, 100, 155)
            End With
            With .Borders(wdBorderVertical)
                .LineStyle = wdLineStyleSingle
                .Color = RGB(50, 100, 155)
            End With
            With .Borders(wdBorderHorizontal)
                .LineStyle = wdLineStyleSingle
                .Color = RGB(50, 100, 155)
            End With
        End With
        ' This collapses the selection
        Selection.Collapse wdCollapseStart
        Else
        End
        End If
        Else
' If the first line does not find another table, this message is displayed.
        MsgBox "There are no more tables in this document"
        End
        End If
        End If
End Sub
Sub IndentTablesSelected()

' Runs through all tables from a user defined start point asking user to indicate whether formatting is to be applied.
' This determines the start point
Response = MsgBox("Start here? Select No to start at beginning of document.", vbYesNoCancel)
If Response = vbYes Then
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This gives warning message if there are no tables beyond start point.
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "There are no tables after this position"
End
End If
ElseIf Response = vbNo Then
Selection.HomeKey Unit:=wdStory
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This gives warning message if there are no tables in the document.
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "There are no tables in this document"
End
End If
Else
End
End If
' This finds the next table from start point and starts the formatting
Do
Response = MsgBox("Apply changes to this table?", vbYesNoCancel)
If Response = vbYes Then
' This selects the table
With Selection
.SelectColumn
.SelectRow
End With
' This formats the table
Selection.Rows.LeftIndent = CentimetersToPoints(2.5)
' This collapses the selection and moves to the next table or displays the end of tables message
Selection.Collapse wdCollapseEnd
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "End of tables in this document"
End
End If
ElseIf Response = vbNo Then
' Selects Table and then collapses to point beyond the table
With Selection
.SelectColumn
.SelectRow
End With
Selection.Collapse wdCollapseEnd
' Looks for next table and loops if found or ends macro
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "End of tables in this document"
End
End If
Else
End
End If
Loop
MsgBox "End of tables in this document"
End Sub

Sub IndentTableNext()

' The same as IndentTablesSelected but for the next table only

' The first line tests whether the cursor is in a table. If it is, the user is asked to confirm.
If Selection.Information(wdWithInTable) = True Then
Response = MsgBox("Apply changes to this table?", vbYesNo)
' If user says Yes, the procedure runs
        If Response = vbYes Then
                ' This selects the table
                With Selection
                .SelectColumn
                .SelectRow
                End With
                ' This formats the table
                With Selection.Tables(1)
                    With .Borders(wdBorderLeft)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderRight)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderTop)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderBottom)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderVertical)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderHorizontal)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                End With
                ' This collapses the selection
                Selection.Collapse wdCollapseStart
        Else
        ' If user says No, the procedure ends
        End
        End If
Else
' If the cursor was not in a table when the procedure was invoked, this section moves it
' to the next table and then runs the same procedure
        Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
        If Selection.Information(wdWithInTable) = True Then
        Response = MsgBox("Apply changes to this table?", vbYesNo)
        If Response = vbYes Then
        ' This selects the table
        With Selection
        .SelectColumn
        .SelectRow
        End With
        ' This formats the table
Selection.Rows.LeftIndent = CentimetersToPoints(2.5)
        ' This collapses the selection
        Selection.Collapse wdCollapseStart
        Else
        End
        End If
        Else
' If the first line does not find another table, this message is displayed.
        MsgBox "There are no more tables in this document"
        End
        End If
        End If
End Sub

Sub OutdentTablesSelected()

' Runs through all tables from a user defined start point asking user to indicate whether formatting is to be applied.
' This determines the start point
Response = MsgBox("Start here? Select No to start at beginning of document.", vbYesNoCancel)
If Response = vbYes Then
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This gives warning message if there are no tables beyond start point.
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "There are no tables after this position"
End
End If
ElseIf Response = vbNo Then
Selection.HomeKey Unit:=wdStory
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
' This gives warning message if there are no tables in the document.
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "There are no tables in this document"
End
End If
Else
End
End If
' This finds the next table from start point and starts the formatting
Do
Response = MsgBox("Apply changes to this table?", vbYesNoCancel)
If Response = vbYes Then
' This selects the table
With Selection
.SelectColumn
.SelectRow
End With
' This formats the table
Selection.Rows.LeftIndent = CentimetersToPoints(0.2)
' This collapses the selection and moves to the next table or displays the end of tables message
Selection.Collapse wdCollapseEnd
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "End of tables in this document"
End
End If
ElseIf Response = vbNo Then
' Selects Table and then collapses to point beyond the table
With Selection
.SelectColumn
.SelectRow
End With
Selection.Collapse wdCollapseEnd
' Looks for next table and loops if found or ends macro
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
If Selection.Information(wdWithInTable) = True Then
Else
MsgBox "End of tables in this document"
End
End If
Else
End
End If
Loop
MsgBox "End of tables in this document"
End Sub
Sub OutdentTableNext()

' The same as OutdentTablesSelected but for the next table only

' The first line tests whether the cursor is in a table. If it is, the user is asked to confirm.
If Selection.Information(wdWithInTable) = True Then
Response = MsgBox("Apply changes to this table?", vbYesNo)
' If user says Yes, the procedure runs
        If Response = vbYes Then
                ' This selects the table
                With Selection
                .SelectColumn
                .SelectRow
                End With
                ' This formats the table
                With Selection.Tables(1)
                    With .Borders(wdBorderLeft)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderRight)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderTop)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderBottom)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderVertical)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                    With .Borders(wdBorderHorizontal)
                        .LineStyle = wdLineStyleSingle
                        .Color = RGB(50, 100, 155)
                    End With
                End With
                ' This collapses the selection
                Selection.Collapse wdCollapseStart
        Else
        ' If user says No, the procedure ends
        End
        End If
Else
' If the cursor was not in a table when the procedure was invoked, this section moves it
' to the next table and then runs the same procedure
        Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""
        If Selection.Information(wdWithInTable) = True Then
        Response = MsgBox("Apply changes to this table?", vbYesNo)
        If Response = vbYes Then
        ' This selects the table
        With Selection
        .SelectColumn
        .SelectRow
        End With
        ' This formats the table
Selection.Rows.LeftIndent = CentimetersToPoints(0.2)
        ' This collapses the selection
        Selection.Collapse wdCollapseStart
        Else
        End
        End If
        Else
' If the first line does not find another table, this message is displayed.
        MsgBox "There are no more tables in this document"
        End
        End If
        End If
End Sub
Sub Heading()
' Runs through all tables in the document and sets the first row as the heading.

' This starts the macro at the start of the document
Selection.HomeKey Unit:=wdStory

'This declares the variable that counts the number of tables.
Dim iNumber As Integer
iNumber = ActiveDocument.Tables.Count

' This stops the macro running if there are no tables
If iNumber = 0 Then
MsgBox "There are no tables in this document"
End
Else

'This declares the variable that numbers the current table.
Dim iCurrent As Integer
For iCurrent = 1 To iNumber

' This finds the next table
Selection.GoTo what:=wdGoToTable, which:=wdGoToNext, Count:=1, Name:=""

' This selects the first row in the table
With Selection
    .SelectRow
End With

' This formats sets the first row to be a Heading
Selection.Rows.HeadingFormat = True

' This loops to the next table until all the tables have been processed.
Next iCurrent
End If
MsgBox "All first rows in tables are now headings."
End Sub
