/***********************************************************************************************************
* $$FileName                   AltTextUpdater.jsx
*
* $$Description	   Sample ExtendScript file to script to update the alt attribute 
*                                            from the screen-tip(title) of the image if alt text is empty.
*
* $$Note                             Uncomment the line below to forcefully update "alt" attribute values from the screentip of the image. 
*                                              //altUpdater.SetForceUpdate(true);
*
* Copyright (c) 2010 Adobe Systems Incorporated. All Rights Reserved.
************************************************************************************************************/

function AltTextUpdater()
{
	var bForceUpdate = false;
	this.SetForceUpdate = function(a_bForceUpdate)
	{
		bForceUpdate = a_bForceUpdate;
	}
	this.UpdateAltTextInTopics = function()
	{
		var rhProject = RoboHelp.project;
		if(typeof(rhProject) == 'undefined')
		{
			alert("Open a RH project and try again");	
		}
		var topicMgr = rhProject.TopicManager;
		var count = 0;
		if(topicMgr.count > 0)
		{
			for(var i=1; i<=topicMgr.count; i++)
			{
				var topicObj = topicMgr.item(i);
				var topicFullPath = topicObj.path;
				count += this.UpdateAltText(topicFullPath);
			}
		}
		return count;
	}
	this.UpdateAltTextInMasterPages = function()
	{
		var rhProject = RoboHelp.project;
		if(typeof(rhProject) == 'undefined')
		{
			alert("Open a RH project and try again");	
		}
		var mPageMgr = rhProject.MasterPageManager;
		var count = 0;
		if(mPageMgr.count > 0)
		{
			for(var i=1; i<=mPageMgr.count; i++)
			{
				var masterPage = mPageMgr.item(i);
				var mPagePath = masterPage.path;
				count += this.UpdateAltText(mPagePath);
			}
		}
		return count;
	}
	this.UpdateAltTextInSnippets = function()
	{
		var rhProject = RoboHelp.project;
		if(typeof(rhProject) == 'undefined')
		{
			alert("Open a RH project and try again");	
		}
		var snippetMgr = rhProject.SnippetManager;
		var count = 0;
		if(snippetMgr.count > 0)
		{
			for(var i=1; i<=snippetMgr.count; i++)
			{
				var snippetObj = snippetMgr.item(i);
				var snippetPath = snippetObj.path;
				count += this.UpdateAltText(snippetPath);
			}
		}
		return count;
	}
	this.UpdateAltText = function(topicFullPath)
	{
		if(File(topicFullPath).exists)
		{
			var bSave = false;
			var tokenMgr = RoboHelp.getTokenManager(topicFullPath);
			if(typeof(tokenMgr) != 'undefined')
			{
				var j = 1;
				for(j=1; j<=tokenMgr.count; j++)
				{
					var tokenObj = tokenMgr.item(j);
					if(tokenObj.tokenType == RoboHelp.TokenType.TOKENTAG)
					{
						//#define TagMaskEndTag		0x10000000
						if(tokenObj.tagType ==  RoboHelp.TagType.TAGIMAGE )
						{
							var altText = tokenObj.getAttribute("alt");
							if(!altText || bForceUpdate)
							{
								var strTitle = tokenObj.getAttribute("title");
								if(strTitle && strTitle != altText)
								{
									tokenObj.setAttribute("alt", strTitle);
									bSave = true;
								}	
							}
						}
					}
				}
				if(bSave)
				{
					tokenMgr.save();
					return 1;
				}
			}
		}
		else
			alert("File does not exist - " + this.topicList[i]);
		return 0;
	}
}

main();

function main()
{
	var altUpdater = new AltTextUpdater();
	
	/*Uncomment the line below to forcefully update "alt" attribute values from the screentip of the image*/
	//altUpdater.SetForceUpdate(true);
	
	var nUpdatedTopics = altUpdater.UpdateAltTextInTopics();
	var nUpdatedMasterPages = altUpdater.UpdateAltTextInMasterPages();
	var nUpdatedSnippets = altUpdater.UpdateAltTextInSnippets();
	alert(nUpdatedTopics+ " topics updated\n"+ nUpdatedMasterPages + " master pages updated\n" + nUpdatedSnippets + " snippets updated.");
	delete altUpdater;
}
	

